;coded by UEZ build 2015-08-07
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <WindowsConstants.au3>

Opt("MustDeclareVars", 1)
Opt("GUIOnEventMode", 1)

Global Const $iWidth = 1000, $iHeight = 500, $fCenterX = $iWidth / 2, $fCenterY = $iHeight / 2

Global $hGUI = GUICreate("GDI+ Rotating Text", $iWidth, $iHeight)

_GDIPlus_Startup()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iWidth, $iHeight)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hGraphic = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetCompositingMode($hGraphic, 0)
_GDIPlus_GraphicsSetCompositingQuality($hGraphic, 2)
_GDIPlus_GraphicsSetPixelOffsetMode($hGraphic, 4)

Global Const $iPen_Size = 3, $hPen = _GDIPlus_PenCreate(0, $iPen_Size)
_GDIPlus_PenSetLineJoin($hPen, 2)

Global Const $hBrush = _GDIPlus_BrushCreateSolid(0xFF000000)

Global Const $iFontSize = 190, $sText = "Loading"
Global Const $hFamily = _GDIPlus_FontFamilyCreate("Times New Roman")
Global Const $hFormat = _GDIPlus_StringFormatCreate()
Global Const $hFont = _GDIPlus_FontCreate($hFamily, $iFontSize, 0)
Global $tLayout = _GDIPlus_RectFCreate(0, 0, $iWidth, $iHeight)
_GDIPlus_StringFormatSetAlign($hFormat, 1)
_GDIPlus_StringFormatSetLineAlign($hFormat, 1)

Global Const $hPath = _GDIPlus_PathCreate()
_GDIPlus_PathAddString($hPath, $sText, $tLayout, $hFamily, 0, $iFontSize, $hFormat)

Global $aDim = _GDIPlus_PathGetWorldBounds($hPath)
Global Const $hIter = _GDIPlus_PathIterCreate($hPath)
Global $iPnt, $iCnt = 0, $aPath, $aTmp[0], $iAdd = 30, $iAdd2 = $iAdd / 2
$aPath = $aTmp
While 1
	$iCnt += 1
	If $iCnt >= UBound($aPath) Then ReDim $aPath[$iCnt + 1]
	$aPath[$iCnt] = _GDIPlus_PathCreate()
	$iPnt = _GDIPlus_PathIterNextMarkerPath($hIter, $aPath[$iCnt])
	If $iPnt <= 0 Then ExitLoop
	_GDIPlus_PathFlatten($aPath[$iCnt], 0.1)
WEnd
$aPath[0] = $iCnt

_GDIPlus_PathIterDispose($hIter)

Global Const $fPi = ACos(-1), $fRad2Deg = 180 / $fPi, $iAmountCorners = 4, $iPerspCorrection = 2500, $fSize = 550
Global $fRotSpeed
Global $aCoordinates[$iAmountCorners][3] = 	[ _;	X			Y			Z
												[	-$fSize, 	-$fSize, 		0], _ ;2
												[ 	$fSize, 	-$fSize, 		0], _ ;3
												[	-$fSize, 	$fSize, 		0], _ ;0
												[ 	$fSize, 	$fSize, 		0]] _ ;1

;	0		1
;
;
;	2		3

GUISetState()

GUISetOnEvent(-3, "Close")

Global $iFPS = 0
AdlibRegister("ShowFPS", 1000)

Do
	Draw_Chars(0, 1, 2, 3)
	$iFPS += 1
Until Not Sleep(10)

Func ShowFPS()
	WinSetTitle($hGUI, "", "Frames: " & $iFPS)
	$iFPS = 0
EndFunc

Func Draw_Chars($p1, $p2, $p3, $p4)
#Region calculate positionn
	Local $x1, $y1, $x2, $y2, $x3, $y3, $x4, $y4, $z1, $z2, $z3
	$x1 = $aCoordinates[$p1][0] * (1 + $aCoordinates[$p1][2] / $iPerspCorrection)
	$y1 = $aCoordinates[$p1][1] * (1 + $aCoordinates[$p1][2] / $iPerspCorrection)
	$z1 = $aCoordinates[$p1][2]
	$x2 = $aCoordinates[$p2][0] * (1 + $aCoordinates[$p2][2] / $iPerspCorrection)
	$y2 = $aCoordinates[$p2][1] * (1 + $aCoordinates[$p2][2] / $iPerspCorrection)
	$z2 = $aCoordinates[$p2][2]
	$x3 = $aCoordinates[$p3][0] * (1 + $aCoordinates[$p3][2] / $iPerspCorrection)
	$y3 = $aCoordinates[$p3][1] * (1 + $aCoordinates[$p3][2] / $iPerspCorrection)
	$z3 = $aCoordinates[$p3][2]
	$x4 = $aCoordinates[$p4][0] * (1 + $aCoordinates[$p4][2] / $iPerspCorrection)
	$y4 = $aCoordinates[$p4][1] * (1 + $aCoordinates[$p4][2] / $iPerspCorrection)

	Local $aPoints_Warp[5][2], $fDeg
	$aPoints_Warp[0][0] = 4
	$aPoints_Warp[1][0] = $fCenterX + $x1
	$aPoints_Warp[1][1] = $fCenterY + $y1
	$aPoints_Warp[2][0] = $fCenterX + $x2
	$aPoints_Warp[2][1] = $fCenterY + $y2
	$aPoints_Warp[3][0] = $fCenterX + $x3
	$aPoints_Warp[3][1] = $fCenterY + $y3
	$aPoints_Warp[4][0] = $fCenterX + $x4
	$aPoints_Warp[4][1] = $fCenterY + $y4
#EndRegion

	_GDIPlus_GraphicsClear($hGraphic, 0xFFFFFFFF)
	Local $i, $hPath_Clone, $aPos, $hMatrix, $hBmp, $hCtxt, $iColor, $iAlpha, $iAlpha2, $fBlur, $iW, $iH
	For $i = 1 To $aPath[0]
		$hPath_Clone = _GDIPlus_PathClone($aPath[$i])
		_GDIPlus_PathWarp($hPath_Clone, Null, $aPoints_Warp, 0, 0, $iWidth, $iHeight)

		$aPos = _GDIPlus_PathGetWorldBounds($hPath_Clone)

		$iW = Int($aPos[2] + $iAdd)
		$iH = Int($aPos[3] + $iAdd)

		$hBmp = _GDIPlus_BitmapCreateFromScan0($iW, $iH)
		$hCtxt = _GDIPlus_ImageGetGraphicsContext($hBmp)

		_GDIPlus_GraphicsSetSmoothingMode($hCtxt, 4)
		_GDIPlus_GraphicsSetPixelOffsetMode($hCtxt, 4)
		_GDIPlus_GraphicsSetCompositingMode($hCtxt, 0)
		_GDIPlus_GraphicsSetCompositingQuality($hCtxt, 2)

		$hMatrix = _GDIPlus_MatrixCreate()
		_GDIPlus_MatrixTranslate($hMatrix, -$aPos[0] + $iAdd2, -$aPos[1] + $iAdd2)
		_GDIPlus_PathTransform($hPath_Clone, $hMatrix)

		Switch $z1
			Case $z1 < 0
				$iColor = Int(Abs($z1) / ($i + 1))
;~ 				$fBlur = Abs(($z1) / 3 + $i * $i) / 25
				$fBlur = Abs($z1 / (20 * ($i + 1)))
			Case Else
				$iColor = Int(Abs($z1) / ($aPath[0] - $i + 1))
;~ 				$fBlur = Abs(($z1) / 3 + $i * $i) / 35
				$fBlur = Abs($z1 / (20 * ($aPath[0] - $i + 1)))
		EndSwitch

		$iColor = $iColor > 0xFF ? 0xFF : $iColor < 0 ? 0 : $iColor
		$iAlpha = 0xFF - Int($iColor / 1.75)
		$iAlpha2 = 0xFF - Int($iColor / 1.5)
;~ 		_GDIPlus_BrushSetSolidColor($hBrush, BitOR($iAlpha * 0x1000000, 0x404040))
;~ 		_GDIPlus_PenSetColor($hPen, BitOR($iAlpha2 * 0x1000000, 0x10000 * $iColor + 0x100 * $iColor + $iColor))
		_GDIPlus_GraphicsDrawPath($hCtxt, $hPath_Clone, $hPen)
		_GDIPlus_GraphicsFillPath($hCtxt, $hPath_Clone, $hBrush)

	    Local $hEffect = _GDIPlus_EffectCreateBlur($fBlur, 1)
		If $fBlur >= 0 Then _GDIPlus_BitmapApplyEffect($hBmp, $hEffect)

		_GDIPlus_GraphicsDrawImageRect($hGraphic, $hBmp, $aPos[0] - $iAdd2, $aPos[1] - $iAdd2, $iW, $iH)

		_GDIPlus_EffectDispose($hEffect)
		_GDIPlus_MatrixDispose($hMatrix)
		_GDIPlus_PathDispose($hPath_Clone)
		_GDIPlus_GraphicsDispose($hCtxt)
		_GDIPlus_BitmapDispose($hBmp)
	Next
	_WinAPI_BitBlt($hDC, 0, 0, $iWidth, $iHeight, $hDC_backbuffer, 0, 0, $SRCCOPY)

#Region rotate points
	Local $x, $y
	Local Static $f = 0
	$fRotSpeed = -0.0333 * Cos($f / 340)
	$f += 10
	For $i = 0 To $iAmountCorners - 1 ;calculate y-axis rotation only
		$x = $aCoordinates[$i][0] * Cos($fRotSpeed) + $aCoordinates[$i][2] * Sin($fRotSpeed)
		$y = -$aCoordinates[$i][0] * Sin($fRotSpeed) + $aCoordinates[$i][2] * Cos($fRotSpeed)
		$aCoordinates[$i][0] = $x
		$aCoordinates[$i][2] = $y
	Next
#EndRegion
EndFunc   ;==>Draw_Chars

Func Close()
	Local $i
	For $i = 1 To $aPath[0]
		_GDIPlus_PathDispose($aPath[$i])
	Next
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_GraphicsDispose($hGraphic)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_DeleteObject($hBrush)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc   ;==>Close